
/* ***************************************************************** 
    MESQUITE -- The Mesh Quality Improvement Toolkit

    Copyright 2004 Sandia Corporation and Argonne National
    Laboratory.  Under the terms of Contract DE-AC04-94AL85000 
    with Sandia Corporation, the U.S. Government retains certain 
    rights in this software.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License 
    (lgpl.txt) along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    diachin2@llnl.gov, djmelan@sandia.gov, mbrewer@sandia.gov, 
    pknupp@sandia.gov, tleurent@mcs.anl.gov, tmunson@mcs.anl.gov      
   
  ***************************************************************** */
  
#include "Mesquite_all_headers.hpp"
//#include "jibum_int_si.cpp"
//#include "jibum_si.cpp"
//#include "jibum_size_metric.cpp"
#include <ostream>
#include <vector>
#include <cstring>
#include <fstream>
//#include "CompositeOFPower.hpp"
#include "CompositeOFExponent.hpp"
#include "CompositeOFNLog.hpp"

using namespace Mesquite;
using namespace std;

template <class T>
bool from_string(T& t, 
                 const std::string& s, 
                 std::ios_base& (*f)(std::ios_base&))
{
  std::istringstream iss(s);
  return !(iss >> f >> t).fail();
}

int main(int argc, char* argv[])
{

	/* float t_threshold, d_threshold, dt;
	d_threshold = 0.001;
	dt = 0.01;
	t_threshold = 2.0/dt;
	int hmrun = 0; */
	MsqError err;

	if (argc != 3) {
		std::cerr << "Usage: lowlevel <input_vtk_file> <#iterations>" << std::endl;
		exit (EXIT_FAILURE);
	}

	int it = atoi(argv[2]);
	cout << "Smoothing in " << it << " iterations" << endl;

	/* ifstream infile;
	float t_error, d_error;
	char tmp[20];
	infile.open("t_error.txt");
	if (infile.is_open()) {
		infile >> tmp;
		//cout << tmp << endl;
		from_string<float>(t_error, tmp, dec);
	}
	infile.close();
	infile.open("d_error.txt");
	if (infile.is_open()) {
		infile >> tmp;
		//cout << tmp << endl;
		from_string<float>(d_error, tmp, dec);
	}
	infile.close();
	cout << "t_threshold = " << t_threshold << "\nd_threshold = " << d_threshold << endl;
	cout << "t_error = " << t_error << "\nd_error = " << d_error << endl; */


	Mesquite::MeshImpl my_mesh;
	my_mesh.read_vtk(argv[1], err);
	if (err) {
		std::cout << err << std::endl;
		return 1;
	}

	//my_mesh.write_vtk("./results/original_mesh.vtk",err);

	Vector3D normal(0,0,1);
	Vector3D point(0,0,0);
	PlanarDomain my_mesh_plane(normal, point);

	// creates a quality metric ...

	IdealWeightInverseMeanRatio int_si_qm(err);
	IdealWeightInverseMeanRatio si_qm(err); 
	//IdealWeightInverseMeanRatio inverse_mean_ratio(err);

	// creat a template
	LPtoPTemplate obj_func1(&int_si_qm, 2, err);
	LPtoPTemplate obj_func2(&si_qm, 2, err);
	double c = 1e+6;
	CompositeOFScalarMultiply obj_func11(1.0/c,&obj_func1,0);
	CompositeOFScalarMultiply obj_func21(1.0/c,&obj_func2,0);
	CompositeOFExponent obj_func12(&obj_func11,0);
	CompositeOFExponent obj_func22(&obj_func21,0);
	CompositeOFAdd obj_func3(&obj_func12, &obj_func22, 0);
	CompositeOFNLog obj_func31(&obj_func3, 0);
	CompositeOFScalarMultiply obj_func(c,&obj_func31,0);
	
	// creates the optimization procedures
	//FeasibleNewton my_solver(&obj_func, err);
	//ConjugateGradient my_solver(&obj_func, err);
	ConjugateGradient my_solver(&obj_func, err);
	//performs optimization globally
	//my_solver.use_global_patch();
	my_solver.use_element_on_vertex_patch();

	// creates a termination criterion and
	// add it to the optimization procedure
	// outer loop: default behavior: 1 iteration
	// inner loop: stop if gradient norm < eps
	TerminationCriterion tc_inner, tc_outer;
	//tc_inner.add_absolute_gradient_L2_norm( 1e-4 );

	// maximum number of iterations
	tc_inner.add_iteration_limit(1);
	tc_outer.add_iteration_limit(it); 

	my_solver.set_inner_termination_criterion(&tc_inner);
	my_solver.set_outer_termination_criterion(&tc_outer);

	// creates a quality assessor
	QualityAssessor int_si_qa(&int_si_qm);
	QualityAssessor si_qa(&si_qm);
	//QualityAssessor final_qa(&final_qm);
	// creates an instruction queue
	InstructionQueue queue;
	
	queue.add_quality_assessor(&int_si_qa, err);
	queue.add_quality_assessor(&si_qa, err);
	//queue.add_quality_assessor(&final_qa, err);
	queue.set_master_quality_improver(&my_solver, err);
	queue.add_quality_assessor(&int_si_qa, err);
	queue.add_quality_assessor(&si_qa, err);
	//queue.add_quality_assessor(&final_qa, err);
	// do optimization of the mesh_set
	queue.run_instructions(&my_mesh, &my_mesh_plane, err);
	if (err) {
	  std::cout << err << std::endl;
	  return 2;
	}
	queue.clear();

my_mesh.write_vtk("/cygdrive/c/dropbox/Dropbox/jibum_research/freefem/FreeFem++/imr2011_parabolic/smoothed_mesh.vtk",err);
	return 0;
}
